<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Book Borrowing Form</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h2>Borrow a Book</h2>
        <form id="borrowForm">
            <div class="form-group">
                <label for="studentId">Student ID</label>
                <input type="text" class="form-control" name="registration_number" id="studentId" placeholder="Enter student ID" required>
            </div>

            <div class="form-group">
                <label for="bookNumber">Book Number</label>
                <input type="text" class="form-control" name="book_number" id="bookNumber" placeholder="Enter book number" required>
            </div>

            <div class="form-group">
                <label for="bookTitle">Book Title</label>
                <input type="text" class="form-control" name="book_title" id="bookTitle" placeholder="Enter book title" required>
            </div>

            <div class="form-group">
                <label for="author">Author</label>
                <input type="text" class="form-control" name="author" id="author" placeholder="Enter author's name" required>
            </div>

            <div class="form-group">
                <label for="borrowDate">Borrow Date</label>
                <input type="date" class="form-control" name="borrow_date" id="borrowDate" required>
            </div>

            <div class="form-group">
                <label for="dueDate">Due Date</label>
                <input type="date" class="form-control" name="due_date" id="dueDate" required>
            </div>

            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
        <div id="responseMessage" class="mt-3"></div>
    </div>

    <script>
        $(document).ready(function() {
            $('#borrowForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission
                $.ajax({
                    type: 'POST',
                    url: 'process_library_book.php', // URL to the PHP script that handles the insertion
                    data: $(this).serialize(), // Serialize form data
                    success: function(response) {
                        $('#responseMessage').html(response); // Show response message
                        $('#borrowForm')[0].reset(); // Reset form after submission
                    },
                    error: function() {
                        $('#responseMessage').html('<div class="alert alert-danger">An error occurred.</div>');
                    }
                });
            });
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>